from flask import Blueprint, Response
import requests

livingabroadtv_bp = Blueprint('livingabroadtv', __name__)

@livingabroadtv_bp.route('/livingabroadtv')
def livingabroadtvplaylist():
    headers = {
        'Accept': '*/*',
        'Accept-Language': 'en-GB,en;q=0.5',
        'Referer': 'https://livingabroad.tv/',
        'Content-Type': 'application/json',
        'Origin': 'https://livingabroad.tv',
    }

    json_data = {
        'data': None,
    }

    response = requests.post(
        'https://us-central1-speedy-district-332216.cloudfunctions.net/getChannels',
        headers=headers,
        json=json_data,
    ).json()

    m3uplaylist = '#EXTM3U\n\n'

    for channel in response['result']['channels']:
        m3uplaylist += f'#EXTINF:-1 tvg-id="{channel["epg_tag"]}" tvg-logo="{channel["imageUrl"]}",{channel["title"]}\n{channel["url"]}\n\n'

    return Response(m3uplaylist, mimetype='audio/x-mpegurl')
